// Copyright 2014 Google Inc. All Rights Reserved.

#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_NAVIGATION_STATUS_ENDPOINT_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_NAVIGATION_STATUS_ENDPOINT_H

#include "common.h"
#include "ProtocolEndpointBase.h"
#include "util/GalMutex.h"
#include "INavigationStatusCallbacks.h"

/**
 * This endpoint is used to send messages to be displayed in the instrument cluster.
 */
class NavigationStatusEndpoint : public ProtocolEndpointBase {
public:
    NavigationStatusEndpoint(uint8_t id, MessageRouter *router, int minIntervalMs,
                              int height, int width, int colourDepthBits,
                              NavigationStatusService_InstrumentClusterType type) :
            ProtocolEndpointBase(id, router, false),
            mMinIntervalMs(minIntervalMs),
            mHeight(height),
            mWidth(width),
            mColourDepthBits(colourDepthBits),
            mType(type) { }

    void addDiscoveryInfo(ServiceDiscoveryResponse *sdr);
    int routeMessage(uint8_t channelId, uint16_t type, const shared_ptr<IoBuffer>& msg);
    void registerCallbacks(const shared_ptr<INavigationStatusCallbacks>& callbacks) {
            mCallbacks = callbacks;
    }

    void start();
    void stop();

private:
    int mMinIntervalMs, mHeight, mWidth, mColourDepthBits;
    NavigationStatusService_InstrumentClusterType mType;
    shared_ptr<INavigationStatusCallbacks> mCallbacks;
    void handleNavigationStatus(const NavigationStatus &status);
    void handleNavigationNextTurnEvent(const NavigationNextTurnEvent &event);
    void handleNavigationDistanceEvent(const NavigationNextTurnDistanceEvent &event);
};

#endif // ANDROID_AUTO_PROJECTION_PROTOCOL_NAVIGATION_STATUS_ENDPOINT_H
